﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Helpers
{
    public static class ExportHelper
    {
        public static StringWriter Export<T>(GridView gv)
        {
            
            using (StringWriter sw = new StringWriter())
            {
                using (HtmlTextWriter htw = new HtmlTextWriter(sw))
                {
                    Table table = new Table();
                    table.GridLines = gv.GridLines;
                    if (gv.HeaderRow != null)
                    {
                        ModifyControlForExport(gv.HeaderRow);
                        table.Rows.Add(gv.HeaderRow);
                    }
                    foreach (GridViewRow row in gv.Rows)
                    {
                        ModifyControlForExport(row);
                        table.Rows.Add(row);
                    }
                    if (gv.FooterRow != null)
                    {
                        ModifyControlForExport(gv.FooterRow);
                        table.Rows.Add(gv.FooterRow);
                    }
                    table.RenderControl(htw);
                }
                return sw;
            }
        }

        private static void ModifyControlForExport(Control control)
        {
            for (int i = 0; i < control.Controls.Count; i++)
            {
                Control current = control.Controls[i];
                if (current is LinkButton)
                {
                    control.Controls.Remove(current);
                    control.Controls.AddAt(i, new LiteralControl((current as LinkButton).Text));
                }
                //else if (current is DataBoundLiteralControl)
                //{
                //    if ((current as DataBoundLiteralControl).Text.ToLower().Contains("control"))
                //        control.Controls.Remove(current);
                //}
                else if (current is Image)
                {
                    control.Controls.Remove(current);
                    control.Controls.AddAt(i, new LiteralControl((current as Image).AlternateText));
                }

                else if (current is Label)
                {
                    control.Controls.Remove(current);
                    control.Controls.AddAt(i, new LiteralControl((current as Label).Text));
                }
                else if (current is LinkButton)
                {
                    control.Controls.Remove(current);
                }
                else if (current is HtmlGenericControl)
                {
                    control.Controls.Remove(current);
                    control.Controls.AddAt(i, new LiteralControl((current as HtmlGenericControl).InnerText));
                }
                else if (current is HtmlInputText)
                {
                    control.Controls.Remove(current);
                }
                else if (current is HyperLink)
                {
                    control.Controls.Remove(current);
                    if(!(current as HyperLink).Text.ToLower().Contains("edit"))
                    control.Controls.AddAt(i, new LiteralControl((current as HyperLink).Text));
                }
                else if (current is Image || current is HtmlImage)
                {
                    control.Controls.Remove(current);
                }
                else if (current is LiteralControl)
                {
                    if ((current as LiteralControl).Text.Contains("<img"))
                        control.Controls.Remove(current);
                }
                else if (current is DropDownList)
                {
                    control.Controls.Remove(current);
                    if ((current as DropDownList).Items.Count != 0)
                    {
                        control.Controls.AddAt(i, new LiteralControl((current as DropDownList).SelectedItem.Text));
                    }
                    else
                    {
                        // controlValue = "";
                    }
                }
                else if (current is CheckBox)
                {
                    control.Controls.Remove(current);
                    control.Controls.AddAt(i, new LiteralControl((current as CheckBox).Checked ? "True" : "False"));
                }
                else if (current is TextBox)
                {
                    control.Controls.Remove(current);
                    TextBox txtBox = current as TextBox;
                    if (txtBox.Style["display"] != "none")
                    {
                        control.Controls.AddAt(i, new LiteralControl((current as TextBox).Text));
                    }
                }
                else if (current is HiddenField)
                {
                    control.Controls.Remove(current);
                }
                else if (current is TableCell)
                {
                    if (current.Parent is DataControlFieldHeaderCell)
                    {
                        if ((current as TableCell).Text.ToLower().Contains("control"))
                        {
                            control.Controls.Remove(current);
                        }
                    }
                }
               
                if (current.HasControls())
                {
                    ModifyControlForExport(current);
                }
            }
        }

    }
}